/*==========================================================
 * damas.c - MEX implementation of DAMAS
 *
 *
 * p = damas(A, b, niter)
 *
 *
 *========================================================*/

#include "mex.h"

/* The computational routine */
void damas(double* A, double* y, mwSize N, int niter, double* z)
{
    mwSize i;
    mwSize j;

    for (i=0; i<N; i++) {
      z[i] = 0;
    }

    int iter = 0;

    for (iter = 0 ; iter < niter; iter++)
    {
      for (i = 0; i < N ; i++)
      {
        z[i] = y[i];
        for (j = 0 ; j < i ; j++)
        {
          z[i] = z[i] - A[i + j*N] * z[j];

        }
        for (j = i+1 ; j < N ; j++)
        {
          z[i] = z[i] - A[i + j*N] * z[j];
        }

	z[i] = ((z[i] > 0) ?  z[i] : 0) / A[i + i*N];
    }
    }
}

/* The gateway function */
void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[])
{
    double *A;               /* 1xN input matrix */
    double *y;
    double niter;              /* input scalar */

    double *outMatrix;              /* output matrix */

    size_t N;

    N = mxGetN(prhs[0]);

    plhs[0] = mxCreateDoubleMatrix((mwSize)N,1,mxREAL);
    outMatrix = mxGetPr(plhs[0]);


    /* create a pointer to the real data in the input matrix  */
    A = mxGetPr(prhs[0]);
    y = mxGetPr(prhs[1]);
    niter = mxGetScalar(prhs[2]);


    damas(A,y,N,niter, outMatrix);
}
