
%% Lawson-Hanson on experimental data
%
% 3D grid of 3.75e5 points

% Approx 15min

% load the data
load damasdemo

% we use all microphones
N = Pmic(:, 2).^2 + Pmic(:, 1).^2;
[~, order] = sort(N);
Nm = 128;
Z = order(1:Nm);
Pmic = Pmic(Z, :);
Data = Data(Z, Z);

close all

% 3D grid
Lx = 150;
Ly = 50;
Lz = 50;
xx = linspace(-2, 1, Lx)';
yy = linspace(-1, 0, Ly)';
zz = linspace(4, 5, Lz)';
[Xg, Yg, Zg] = meshgrid(xx, yy, zz);

D = dictionary(Pmic, [Xg(:) Yg(:) Zg(:)], k);
%% Lawson-Hanson algorithm

tic;xlh = cmf_nnls(D, Data, 1e2); Tnd = toc;
Clh = norm(D*spdiags(xlh,0,size(D, 2), size(D,2))*D' - Data, 'fro');

save 3Dexp

%% 3D plot
figure

% we threshold the powers for clarity
support = xlh(:) > 0;%max(xlh(:))/100;

% color
C = [0.2,0.2,0.2];
alpha = 0.2;

scatter3(Xg(support), Zg(support), Yg(support), (xlh(support)+eps)/10000, C, 'filled')
hold on

% projections (shaded)
scatter3(Xg(support), Zg(support)*0+5, Yg(support), (xlh(support)+eps)/10000, 1 - alpha * (1 - C), 'filled')
scatter3(Xg(support), Zg(support), Yg(support)*0-1, (xlh(support)+eps)/10000, 1 - alpha * (1 - C), 'filled')

axis equal
xlim([-2, 1])
ylim([4, 5])
zlim([-1, 0])

xlabel("X")
ylabel("Z")
zlabel("Y")

%%

figure

[xs, ys, zs] = sphere();

sup = find(support);

for u = 1:length(sup)
    r = (xlh(sup(u))+eps)/20000000;
    surf(xs*r + Xg(sup(u)), ys*r + Zg(sup(u)),zs*r + Yg(sup(u)), repmat(0.8, 21,21, 3),'FaceLighting', 'gouraud')
    shading interp
    colormap(gray)
    hold on

end


% projections (shaded)
scatter3(Xg(support), Zg(support)*0+5, Yg(support), (xlh(support)+eps)/10000, 1 - alpha * (1 - C), 'filled')
scatter3(Xg(support), Zg(support), Yg(support)*0-1, (xlh(support)+eps)/10000, 1 - alpha * (1 - C), 'filled')

axis equal
xlim([-2, 1])
ylim([4, 5])
zlim([-1, 0])

xlabel("X")
ylabel("Z")
zlabel("Y")
camlight('right')

