

%% Compares DAMAS and CMF-NNLS 
%%  on simulated data
%
% 2D grid of 2500 points
load damasdemo

N = Pmic(:, 2).^2 + Pmic(:, 1).^2;

[~, order] = sort(N);

Nm = 64;

Z = order(1:Nm);

Pmic = Pmic(Z, :);

Data = Data(Z, Z);

close all

Lx = 100;
Ly = 100;
Lz = 1;
xx = linspace(0, 2, Lx+1)';
yy = linspace(0, 2, Ly+1)';
xx = xx(1:end-1);
yy = yy(1:end-1);
zz = 4.4;
[Xg, Yg, Zg] = meshgrid(xx, yy, zz);


D = dictionary(Pmic, [Xg(:) Yg(:) Zg(:)], k);

% indexes of the sources
idx = [1125 8234];

% sources power 
% /!\ variances of real and imaginary part, power is multiplied by 2
sigma_source1 = 1;
sigma_source2 = 4;

% noise variances (first and last 32 sensors)
% same remark
sigma_noise1 = 0.4;
sigma_noise2 = 1.6;

% number of snapshots
N = 200;

% large DAMAS matrix
% normalized beamforming matrix
Dbf = D ./ sum(abs(D).^2, 1);

% masks for estimating the powers
[r1, c1] = ind2sub([Ly, Lx], idx(1));
[r2, c2] = ind2sub([Ly, Lx], idx(2));

mask1 = zeros(Ly, Lx);
mask1(r1-1:r1+1, c1-1:c1+1) = 1;
mask1 = logical(mask1);

mask2 = zeros(Ly, Lx);
mask2(r2-1:r2+1, c2-1:c2+1) = 1;
mask2 = logical(mask2);
Nt = 10;


% powers of the sources
% beamforing without/with diagonal removal
PBF = zeros(2, Nt);
% DAMAS without/with diagonal removal
PD = zeros(2, Nt);
% LH without/with noise estimation
PLH = zeros(2, Nt);
PLHnoise = zeros(2, Nt);


% LH with noise estimation, estimated noise variances
LHnoiseest = zeros(64, Nt);


%% otherwise load from a precomputed matrix
load DDdr

Niter = 500;

C1 = D(:, idx(1)) * D(:, idx(1))';
C1 = C1 - diag(diag(C1));
C1 = C1 / sum(abs(C1(:)).^2);

C2 = D(:, idx(2)) * D(:, idx(2))';
C2 = C2 - diag(diag(C2));
C2 = C2 / sum(abs(C2(:)).^2);
for u = 1:Nt
    
    waitbar(u/Nt)

    %% simulation of the data
    sigs =  D(:, idx) * (sqrt([sigma_source1 sigma_source2]') .* (randn(length(idx), N) + 1i * randn(length(idx), N))); 
    noise = sqrt([ones(32, 1) * sigma_noise1 ; ones(32, 1) * sigma_noise2]) .* (randn(size(D, 1), N) + 1i * randn(size(D, 1), N));
    Data = (sigs + noise) * (sigs + noise)' /N;

    SNR = 20*log10(norm(sigs, 'fro')/norm(noise, 'fro'));

%% Beamforming
    Cbf = sum(conj(D) .* (Data*D), 1);
    Cbf = real(Cbf');

% normalized
    Cbfp = sum(conj(Dbf) .* (Data*Dbf), 1);
    Cbfp = real(Cbfp');

    
    
    PBF(:, u) = Cbfp(idx);

    PBF(1, u) = real(trace(Data*C1));
    PBF(2, u) = real(trace(Data*C2));



% diagonal removal
    DataDR = Data - diag(diag(Data));
    CbfDR = sum(conj(D) .* (DataDR*D), 1);
    CbfDRdamas = real(CbfDR');


%% optimized NNLS noise with noise estimation

tic;

Dnoise = [D eye(size(D, 1))];
xlhnoise = cmf_nnls(Dnoise, Data, 1e-8);
Tlhnoise(u) = toc;

% source powers
PLHnoise(1, u) = sum(xlhnoise(mask1));
PLHnoise(2, u) = sum(xlhnoise(mask2));
% noise variances
LHnoiseest(:, u) = xlhnoise(end-63:end);

%% optimized NNLS DR

tic
xlh = cmf_nnls_dr(D, DataDR, 1e-8);
Tlh(u) = toc;

PLH(1, u) = sum(xlh(mask1));
PLH(2, u) = sum(xlh(mask2));



%% DAMAS, diagonal removal

tic
xd = damas_nnls_dr(D, real(CbfDRdamas), 1e-8);

Td(u) = toc;

PD(1, u) = sum(xd(mask1));
PD(2, u) = sum(xd(mask2));




end

clear DDdr DD

save 2Dsim

%%
close all
figure

boxplot([ PBF(1, :)  ;PD(1, :) ; PLH(1, :)]')


hold on
boxplot([ PBF(2, :) ; PD(2, :) ; PLH(2, :)]')


plot([0, 5], sigma_source1*[2 2], 'linewidth', 2, 'Color', [1 1 1]*0.7)
plot([0, 5], sigma_source2*[2 2], 'linewidth', 2, 'Color', [1 1 1]*0.7)

names = {'BF', 'DAMAS', 'CMF-NNLS'};
set(gca,'xtick',[1:4],'xticklabel',names)
ylim([0 11])
grid on
ylabel('Source powers')


figure

choices = randperm(32);
choices = sort(choices(1:4));

plot([0, 4.5], 2*sigma_noise1*[1 1], 'linewidth', 2, 'Color', [1 1 1]*0.7)
hold on

plot([4.5, 9], 2*sigma_noise2*[1 1], 'linewidth', 2, 'Color', [1 1 1]*.7)

boxplot(LHnoiseest([choices choices+32], :)')
set(gca,'xtick',[1:8],'xticklabel',[choices choices+32])
grid on
xlabel('Microphone')
ylabel('Noise level')
ylim([0 4])


%%
m = -30;
M = max(10*log10(Cbf));

subplot(2, 2, 1)

scatter(Xg(idx), Yg(idx), [1 4]*20, 'k', 'filled')
xlim([0, 1])
ylim([0, 1])
axis square
colorbar
title("Sources")

subplot(2, 2, 2)

imagesc(xx, yy, 10*log10(reshape(Cbf, Lx, Ly)))
axis xy
axis square
colormap((hot))
colorbar
ax = gca;
ax.CLim =[m M];
title("BF")

subplot(2, 2, 3)

imagesc(xx, yy, 10*log10(reshape(xd, Lx, Ly)))
axis xy
axis square
colormap((hot))
colorbar
ax = gca;
ax.CLim =[m M];
title("DAMAS")

subplot(2, 2, 4)

imagesc(xx, yy, 10*log10(reshape(xlh, Lx, Ly)))
axis xy
axis square
colormap((hot))
colorbar
ax = gca;
ax.CLim =[m M];
title("CMF-NNLS")

%%

figure

% /!\ *2 because of complex random variables
ss = [sigma_source1 ; sigma_source2] * 2;
eBF = mean((PBF - ss).^2, 2);
eD = mean((PD - ss).^2, 2);
eLH = mean((PLH - ss).^2, 2);
eLHnoise = mean((PLHnoise - ss).^2, 2);


scatter(1:3,[ eBF(1, :) ;  eD(1, :) ; eLH(1, :) ]', 100, 'ko', 'filled')
hold on
scatter(1:3,[ eBF(2, :) ;  eD(2, :) ; eLH(2, :)]', 100, 'k+', 'linewidth', 2)

legend('First sources', 'Second source')

ylabel('MSE')
grid on

names = {'BF', 'DAMAS', 'CMF-NNLS'};
set(gca,'xtick',1:3,'xticklabel',names)
xlim([0.5 3.5])